package cn.com.duiba.scrm.center.api.param.tag;

import cn.com.duiba.scrm.common.enums.db.tag.TagBizTypeEnum;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * 本地打标签参数
 * @author xiaotian
 * @description
 * @date ：Created in 2021/7/30
 */

@Getter
@Setter
public class MakeTagSeriesParam extends TagBaseOperateParam {

    /**
     * 标签类型
     */
    private TagBizTypeEnum tagBizTypeEnum;
    /**
     * 业务id
     */
    private Long bizId;

    /**
     * 添加标签列表
     */
    private List<Long> addTagList;

    /**
     * 删除的标签列表
     */
    private List<Long> removeTagList;

    public MakeTagSeriesParam() {

    }

    public MakeTagSeriesParam(TagBizTypeEnum tagBizTypeEnum, Long bizId, List<Long> addTagList, List<Long> removeTagList) {
        this.tagBizTypeEnum = tagBizTypeEnum;
        this.bizId = bizId;
        this.addTagList = addTagList;
        this.removeTagList = removeTagList;
    }
}
