package cn.com.duiba.scrm.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.param.chatgroup.ChatGroupMemberQueryParam;
import cn.com.duiba.scrm.center.api.param.chatgroup.ChatGroupQueryParam;
import cn.com.duiba.scrm.center.api.param.code.EmpleCodeStatisticsQueryParam;
import cn.com.duiba.scrm.center.api.param.customer.CodeCustomerQueryParam;
import cn.com.duiba.scrm.center.api.param.customer.CustomerQueryParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

/**
 * 数据导出收拢
 *
 * @author zsp (zengshuiping@duiba.com.cn)
 * @date 2021/8/7 14:18
 */
@AdvancedFeignClient
public interface RemoteDataExportService {

    /**
     * 活码数据导出-按日期
     */
    ScrmResult<String> export4statisticsForTime(EmpleCodeStatisticsQueryParam param, String businessKey);

    /**
     * 活码数据导出-按员工
     */
    ScrmResult<String> export4statisticsForUser(CodeCustomerQueryParam param, String businessKey);


    /**
     * 客户导出
     */
    ScrmResult<String> export4WechatCustomer(CustomerQueryParam param, String businessKey);


    /**
     * 客户群导出
     */
    ScrmResult<String> export4ChatGroup(ChatGroupQueryParam param, String businessKey);


    /**
     * 客户群成员导出
     */
    ScrmResult<String> export4ChatGroupMember(ChatGroupMemberQueryParam param, String businessKey);
}
