package cn.com.duiba.scrm.center.api.remoteservice.groupmsg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.groupmsg.GroupMsgSendResultDto;
import cn.com.duiba.scrm.center.api.param.groupmsg.GroupMsgQueryParam;
import cn.com.duiba.scrm.center.api.param.groupmsg.GroupMsgTaskSendResultQueryParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;
import java.util.Map;

/**
* 群发成员执行结果 RemoteService
* @author xiaotian
* 2021-7-30 13:39:38
*/
@AdvancedFeignClient
public interface RemoteGroupMsgSendResultService {
    /**
    * 新增记录
    */
    @Deprecated
	Boolean save(GroupMsgSendResultDto dto);

    /**
    * 根据id删除
    */
    @Deprecated
    Boolean deleteById(Long id);
    /**
    * 根据id更新
    */
    @Deprecated
    Boolean updateById(GroupMsgSendResultDto dto);
    /**
    * 根据id获取
    */
    @Deprecated
    GroupMsgSendResultDto getById(Long id);

    /**
     * 根据查询条件统计数据
     */
    ScrmResult<Map<Long, Long>> countByParam(GroupMsgTaskSendResultQueryParam groupMsgTaskSendResultQueryParam);

    /**
     * 根据查询条件查询
     */
    ScrmResult<List<GroupMsgSendResultDto>> getByConditions(GroupMsgQueryParam groupMsgQueryParam);


    /**
     * 根据查询条件查询
     */
    ScrmResult<List<GroupMsgSendResultDto>> getByTaskId(Long taskId);

    /**
     * 根据筛选条件查询
     */
    ScrmResult<List<GroupMsgSendResultDto>> getByParam(GroupMsgTaskSendResultQueryParam param);
}
