package cn.com.duiba.scrm.center.api.remoteservice.material;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.material.MaterialDto;
import cn.com.duiba.scrm.center.api.param.material.MaterialPageQueryParam;
import cn.com.duiba.scrm.center.api.param.material.MaterialQueryParam;
import cn.com.duiba.scrm.center.api.param.material.MaterialSaveParam;
import cn.com.duiba.scrm.center.api.param.material.WelcomeMsgPageQueryParam;
import cn.com.duiba.scrm.common.enums.db.BizTypeEnum;
import cn.com.duiba.scrm.common.enums.db.material.MaterialBizTypeEnum;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 素材表 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 10:32:28
 */
@AdvancedFeignClient
public interface RemoteMaterialService {
    /**
     * 新增记录
     */
    @Deprecated
    Long save(MaterialDto dto);

    ScrmResult<Boolean> saveBatch(List<MaterialDto> dto);

    /**
     * 根据id删除
     */
    @Deprecated
    Boolean deleteById(Long id);

    /**
     * 根据id更新
     */
    @Deprecated
    Boolean updateById(MaterialDto dto);

    /**
     * 根据id获取
     */
    @Deprecated
    MaterialDto getById(Long id);

    /**
     * 根据ID获取
     *
     * @param id
     * @return
     */
    ScrmResult<MaterialDto> getByIdWithResult(Long id);

    /**
     * 获取素材列表
     *
     * @param dto
     * @return
     */
    @Deprecated
    ScrmResult<List<MaterialDto>> getByDto(MaterialDto dto);

    @Deprecated
    ScrmResult<ScrmPageResult<MaterialDto>> getWelcomeMsgPageVos(WelcomeMsgPageQueryParam query);

    ScrmResult<Integer> delByBizId(BizTypeEnum type, Long bizId);

    @Deprecated
    ScrmResult<List<MaterialDto>> getByBizIds(BizTypeEnum type, List<Long> bizId);

    ScrmResult<List<MaterialDto>> getByBizIds(MaterialBizTypeEnum type, List<Long> bizId);

    @Deprecated
    ScrmResult<Boolean> saveBatchMaterials(List<MaterialSaveParam> materials);

    @Deprecated
    ScrmResult<List<MaterialDto>> getByBizIdsAuth(MaterialQueryParam materialQueryParam);
    /**
     * 获取素材根据条件
     * @param query
     * @return
     */
    @Deprecated
    ScrmResult<ScrmPageResult<MaterialDto>>  getMaterialByCondition(MaterialPageQueryParam query);

    /**
     * 根据条件查询素材
     */
    ScrmResult<ScrmPageResult<MaterialDto>> pageQuery(MaterialPageQueryParam materialQueryParam);
}
