package cn.com.duiba.scrm.center.api.remoteservice.radar;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.material.MaterialDto;
import cn.com.duiba.scrm.center.api.dto.radar.SocialRadarDto;
import cn.com.duiba.scrm.center.api.param.social.radar.ShareLinkParamBean;
import cn.com.duiba.scrm.center.api.param.social.radar.SocialRadarActionParam;
import cn.com.duiba.scrm.center.api.param.social.radar.SocialRadarAddParam;
import cn.com.duiba.scrm.center.api.param.social.radar.SocialRadarPageQueryParam;
import cn.com.duiba.scrm.common.enums.db.channel.DefaultRadarChannelEnum;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 互动雷达表 RemoteService
 *
 * @author xiaotian
 * 2021-8-26 10:48:56
 */
@AdvancedFeignClient
public interface RemoteSocialRadarService {
    /**
     * 新增记录
     */
    ScrmResult<Boolean> save(SocialRadarDto dto);

    /**
     * 根据id更新
     */
    ScrmResult<Boolean> updateById(SocialRadarDto dto);

    /**
     * 根据id获取
     */
    ScrmResult<SocialRadarDto> getById(Long id);

    /**
     * 分页查询雷达链接列表
     *
     * @param socialRadarPageQueryParam
     *
     * @return
     */
    ScrmResult<List<SocialRadarDto>> pageQueryRadar(SocialRadarPageQueryParam socialRadarPageQueryParam);

    /**
     * 统计雷达链接数量
     *
     * @param socialRadarPageQueryParam
     *
     * @return
     */
    ScrmResult<Long> count(SocialRadarPageQueryParam socialRadarPageQueryParam);

    /**
     * 删除雷达链接
     *
     * @param id
     *
     * @return
     */
    ScrmResult<Boolean> delById(Long id);

    /**
     * 添加雷达链接
     *
     * @param socialRadarAddParam
     *
     * @return
     */
    ScrmResult<Boolean> add(SocialRadarAddParam socialRadarAddParam);


    /**
     * 雷达链接行为
     *
     * @param socialRadarActionParam
     * @return
     */
    ScrmResult<Boolean> radarAction(SocialRadarActionParam socialRadarActionParam);

    /**
     * 获取点击分享雷达链接
     *
     * @param shareLinkParam
     * @return
     */
    ScrmResult<String> shareLink(ShareLinkParamBean shareLinkParam);

    /**
     * 替换雷达链接素材
     *
     * @param materialDto
     * @param channelEnum
     * @param shareUserId
     * @return
     */
    ScrmResult<MaterialDto> convertMaterial(MaterialDto materialDto, DefaultRadarChannelEnum channelEnum, Long shareUserId);

    /**
     * 查询雷达链接列表
     *
     * @param scCorpId
     * @param radarIdList
     * @return
     */
    ScrmResult<List<SocialRadarDto>> getByCorpIdAndIdList(Long scCorpId, List<Long> radarIdList);
}
