package cn.com.duiba.scrm.center.api.remoteservice.shorcut;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.shorcut.ShortcutPhraseDto;
import cn.com.duiba.scrm.center.api.param.phrase.ShortcutPhraseBatchSaveParam;
import cn.com.duiba.scrm.center.api.param.phrase.ShortcutPhraseBatchUpdateParam;
import cn.com.duiba.scrm.center.api.param.phrase.ShortcutPhraseIdParam;
import cn.com.duiba.scrm.center.api.param.phrase.ShortcutPhraseParam;
import cn.com.duiba.scrm.common.result.ScrmResult;

/**
 * 话术表 RemoteService
 *
 * @author xiaotian
 * 2021-7-31 19:54:47
 */
@AdvancedFeignClient
public interface RemoteShortcutPhraseService {
    /**
     * 新增记录
     */
    ScrmResult<Boolean> save(ShortcutPhraseParam shortcutPhraseParam);

    /**
     * 根据id删除
     */
    ScrmResult<Boolean> deleteById(ShortcutPhraseIdParam param);

    /**
     * 根据id更新
     */
    ScrmResult<Boolean> updateById(ShortcutPhraseParam shortcutPhraseParam);

    /**
     * 根据id获取
     */
    ScrmResult<ShortcutPhraseDto> getById(ShortcutPhraseIdParam  param);

    /**
     * 批量保存
     */
    ScrmResult<Boolean> batchSave(ShortcutPhraseBatchSaveParam shortcutPhraseBatchSaveParam);

    /**
     * 批量更新
     * @param param
     * @return
     */
    ScrmResult<Boolean> updateBatchById(ShortcutPhraseBatchUpdateParam param);
}
