package cn.com.duiba.scrm.center.api.remoteservice.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.api.dto.tag.TagGroupDetailDto;
import cn.com.duiba.scrm.center.api.dto.tag.TagGroupDto;
import cn.com.duiba.scrm.center.api.param.TagGroupQueryParam;
import cn.com.duiba.scrm.common.enums.db.tag.TagTypeEnum;
import cn.com.duiba.scrm.common.result.ScrmPageResult;
import cn.com.duiba.scrm.common.result.ScrmResult;

import java.util.List;

/**
 * 标签组 RemoteService
 *
 * @author xiaotian
 * 2021-7-24 19:23:52
 */
@AdvancedFeignClient
public interface RemoteTagGroupService {

    ScrmResult<ScrmPageResult<TagGroupDetailDto>> queryPage(TagGroupQueryParam queryParam);


    /**
     * 默认是获取企微的群组信息
     *
     * @param scCorpId
     * @param groupIds
     * @return
     */
    ScrmResult<List<TagGroupDto>> getByIds(Long scCorpId, List<String> groupIds);


    /**
     * 通过类型区分标签组类型
     *
     * @param scCorpId
     * @param groupIds
     * @return
     */
    ScrmResult<List<TagGroupDto>> getByTypeAndIds(Long scCorpId, TagTypeEnum tagTypeEnum, List<String> groupIds);
}
