package cn.com.duiba.scrm.center.open.api.dto;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：企微分页包装类
 *
 * @Auther: xiaotian
 * @Date: 2021/10/11 20:09
 * @Description:
 */
public class ScrmOpenPageResult<T> implements Serializable {

    private List<T> list;

    private Long totalCount;

    private Integer pageNum;

    private Integer pageSize;

    public ScrmOpenPageResult(List<T> data, Long totalCount) {
        this.list = data;
        this.totalCount = totalCount;
    }

    public ScrmOpenPageResult(List<T> data, Long totalCount, Integer pageNum, Integer pageSize) {
        this.list = data;
        this.totalCount = totalCount;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }
    public ScrmOpenPageResult(Long totalCount, Integer pageNum, Integer pageSize) {
        this.totalCount = totalCount;
        this.pageNum = pageNum;
        this.pageSize = pageSize;
    }


    public List<T> getList() {
        return list;
    }

    public void setList(List<T> list) {
        this.list = list;
    }

    public Long getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}
