package cn.com.duiba.scrm.center.open.api.dto;

import java.io.Serializable;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2021/10/11 10:56
 * @Description:
 */
public class ScrmOpenResult<T> implements Serializable {

    private static final long serialVersionUID = 5798611079247264491L;
    private Boolean success;
    private String code;
    private String desc;
    private T data;

    private ScrmOpenResult(boolean success, T data, String desc) {
        this.success = success;
        this.desc = desc;
        this.data = data;
    }

    private ScrmOpenResult(Boolean success, String code, String desc, T data) {
        this.success = success;
        this.code = code;
        this.desc = desc;
        this.data = data;
    }

    public static <T> ScrmOpenResult<T> success(T t) {
        return new ScrmOpenResult<>(true, t, "");
    }

    public static <T> ScrmOpenResult<T> fail(String message) {
        return new ScrmOpenResult<>(false, null, message);
    }

    public static <T> ScrmOpenResult<T> fail(String code, String message) {
        return new ScrmOpenResult<>(false, code, message, null);
    }

    public static <T> ScrmOpenResult<T> getInstance(boolean success) {
        return new ScrmOpenResult<>(success, null, null, null);
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
