package cn.com.duiba.scrm.center.open.api.param.chatgroup;

import cn.com.duiba.scrm.center.open.api.param.ScrmOpenBaseParam;

/**
 * 功能描述： 分页查询基础参数
 *
 * @Auther: xiaotian
 * @Date: 2021/10/12 14:16
 * @Description:
 */
public class ScrmOpenPageQuery extends ScrmOpenBaseParam {

    private static final long serialVersionUID = -4672605550197670227L;

    /**
     * 查询页码 默认1 第一页
     */
    private int current = 1;
    /**
     * 查询条数 默认20条
     */
    private int pageSize = 20;

    private int offset;

    public ScrmOpenPageQuery() {
    }

    public ScrmOpenPageQuery(int current, int pageSize) {
        this.current = current;
        this.pageSize = pageSize;
    }

    public int getOffset() {
        offset = current >= 1 ? (current - 1) * pageSize : 0;
        return offset;
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

}
