package cn.com.duiba.scrm.center.open.api.remoteservice.chatgroup;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.center.open.api.dto.ScrmOpenPageResult;
import cn.com.duiba.scrm.center.open.api.dto.ScrmOpenResult;
import cn.com.duiba.scrm.center.open.api.dto.chatgroup.ChatGroupMemberOpenDto;
import cn.com.duiba.scrm.center.open.api.dto.chatgroup.ChatGroupOpenDto;
import cn.com.duiba.scrm.center.open.api.param.chatgroup.ChatMemberCountParam;
import cn.com.duiba.scrm.center.open.api.param.chatgroup.ChatMemberInChatParam;
import cn.com.duiba.scrm.center.open.api.param.chatgroup.ChatMemberListParam;
import cn.com.duiba.scrm.center.open.api.param.chatgroup.ChatMemberPageQuery;
import cn.com.duiba.scrm.center.open.api.param.chatgroup.ScrmOpenPageQuery;

import java.util.List;

/**
 * 企业微信群 RemoteService
 *
 * @author xiaotian
 * 2021-10-10 13:52:14
 */
@AdvancedFeignClient
public interface RemoteOpenChatGroupService {


    /**
     * 判断是否在群
     *
     * @param chatMemberInChatParam
     * @return
     */
    ScrmOpenResult<Boolean> memberInChat(ChatMemberInChatParam chatMemberInChatParam);


    /**
     * 获取实时在群人数接口
     *
     * @param chatMemberCountParam
     * @return
     */
    ScrmOpenResult<Long> chatMemberCount(ChatMemberCountParam chatMemberCountParam);


    /**
     * 分页查询群列表
     *
     * @param scrmOpenPageQuery
     * @return
     */
    ScrmOpenResult<ScrmOpenPageResult<ChatGroupOpenDto>> queryChatList(ScrmOpenPageQuery scrmOpenPageQuery);


    /**
     * 筛选群聊人员列表接口
     * 一次性返回，最大500
     *
     * @param chatMemberListParam
     * @return
     */
    ScrmOpenResult<List<ChatGroupMemberOpenDto>> queryChatMember(ChatMemberListParam chatMemberListParam);

    /**
     * 翻页查询群聊人员列表
     * @param chatMemberPageQuery
     * @return
     */
    ScrmOpenResult<ScrmOpenPageResult<ChatGroupMemberOpenDto>> queryChatMemberV2(ChatMemberPageQuery chatMemberPageQuery);

}
