package cn.com.duiba.scrm.common.util;

import org.apache.commons.lang3.StringUtils;

/**
 * Created by zhangshun on 2019/6/3.
 */
public class EmojiUtils {

    private static boolean isCharacter(char codePoint) {
        return (codePoint == 0x0) || (codePoint == 0x9) || (codePoint == 0xA)
                || (codePoint == 0xD)
                || ((codePoint >= 0x20) && (codePoint <= 0xD7FF))
                || ((codePoint >= 0xE000) && (codePoint <= 0xFFFD))
                || ((codePoint >= 0x10000) && (codePoint <= 0x10FFFF));
    }

    /**
     * 过滤emoji 或者 其他非文字类型的字符
     *
     * @param source
     * @return
     */
    public static String filterEmoji(String source) {
        if (StringUtils.isBlank(source)) {
            return source;
        }
        StringBuilder buf = null;
        int len = source.length();
        for (int i = 0; i < len; i++) {
            char codePoint = source.charAt(i);
            if (isCharacter(codePoint)) {
                if (buf == null) {
                    buf = new StringBuilder(source.length());
                }
                buf.append(codePoint);
            }
        }
        if (buf == null) {
            return "";
        } else {
            if (buf.length() == len) {
                buf = null;
                return source;
            } else {
                return buf.toString();
            }
        }
    }

    public static String replaceEmoji(String source) {
        if (StringUtils.isBlank(source)) {
            return source;
        }
        int len = source.length();
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; i++) {
            char codePoint = source.charAt(i);
            if (isCharacter(codePoint)) {
                buf.append(codePoint);
            } else {
                buf.append("囗");
                i++;
            }
        }
        return getResult(source, buf);
    }

    private static String getResult(String source, StringBuilder buf) {
        if (buf == null) {
            return "";
        } else {
            if (buf.length() == source.length()) {
                return source;
            } else {
                return buf.toString();
            }
        }
    }

    /**
     * 判断字符串中是否含有表情
     * @param source
     * @return
     */
    public static Boolean containsEmoji(String source) {
        if (StringUtils.isBlank(source)) {
            return false;
        }
        int len = source.length();
        boolean containsEmoji = false;
        for (int i = 0; i < len; i++) {
            char hs = source.charAt(i);
            if (!isCharacter(hs)){
                containsEmoji = true;
                break;
            }
        }
        return containsEmoji;
    }
}
