/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Xml2JSONUtil {
    private static final Logger log = LoggerFactory.getLogger(Xml2JSONUtil.class);

    private Xml2JSONUtil() {
    }

    public static void main(String[] args) throws Exception {
        String xml = "<xml>\n<ToUserName><![CDATA[appid]]></ToUserName>\n<Encrypt><![CDATA[uh61qGXGuazikXCy4xE1bx/IWTuz6UbkW/2bSu2BgUPmA/SyAEfvOwblJiaSJ/AQIQa3rwZ9+owdfIqBiyVfYqnnRqmjJe1ekqQjjNxPjfETWWZIddqf7mnYf8aOn9AuAqPYv9bVOi64t/jKPZRP9EHdAZByGchSxMsTXTsjcZR4q+dUrF7Odkmum6HXOuhgRJb8izzCLHOIW4Oo540F5Hng8DJYbkd8N2lsV6dSfE75ZGWpJ4G/ZSO46cfmd7TzdvdaDU+7NJpP8BJO+Sc2+KyZcxg5vi1YMPsElEiQeZwMief9CcdpnZkJFK75QHk5t788zDmfQEHLU9l4MvBqOMlX5RN7Fdo3S/0B9w8TawVWMs9qv38J+jTBoxwm+vsBnz7HyYakXCW+VcwEpHBjB2PLovGRTNcMPyfuLFSQkuA0hUNpGV00BEmQcG7HTvuiQPLqvdiS7BHAawZCvsUs5A==]]></Encrypt>\n</xml>";
        System.out.println(Xml2JSONUtil.xml2Json(xml));
    }

    public static JSONObject xml2Json(String xml) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            JSONObject json = new JSONObject();
            Xml2JSONUtil.dom4j2Json(doc.getRootElement(), json);
            return json;
        }
        catch (DocumentException e) {
            log.error("parse xml to json has error ! xml={}", (Object)xml, (Object)e);
            return null;
        }
    }

    public static <T> T xml2Object(String xml, Class<T> clazz) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            JSONObject json = new JSONObject();
            Xml2JSONUtil.dom4j2Json(doc.getRootElement(), json);
            return (T)json.toJavaObject(clazz);
        }
        catch (DocumentException e) {
            log.error("parse xml to object has error ! xml={} class={}", new Object[]{clazz.getSimpleName(), xml, e});
            return null;
        }
    }

    private static void dom4j2Json(Element element, JSONObject json) {
        for (Object o : element.attributes()) {
            Attribute attr = (Attribute)o;
            if (Xml2JSONUtil.isEmpty(attr.getValue())) continue;
            json.put("@" + attr.getName(), (Object)attr.getValue());
        }
        List chdEl = element.elements();
        if (chdEl.isEmpty() && !Xml2JSONUtil.isEmpty(element.getText())) {
            json.put(element.getName(), (Object)element.getText());
        }
        for (Element e : chdEl) {
            if (!e.elements().isEmpty()) {
                JSONObject chdjson = new JSONObject();
                Xml2JSONUtil.dom4j2Json(e, chdjson);
                Object o = json.get((Object)e.getName());
                if (o != null) {
                    JSONArray jsona = null;
                    if (o instanceof JSONObject) {
                        JSONObject jsono = (JSONObject)o;
                        json.remove((Object)e.getName());
                        jsona = new JSONArray();
                        jsona.add((Object)jsono);
                        jsona.add((Object)chdjson);
                    }
                    if (o instanceof JSONArray) {
                        jsona = (JSONArray)o;
                        jsona.add((Object)chdjson);
                    }
                    json.put(e.getName(), (Object)jsona);
                    continue;
                }
                if (chdjson.isEmpty()) continue;
                json.put(e.getName(), (Object)chdjson);
                continue;
            }
            for (Object o : element.attributes()) {
                Attribute attr = (Attribute)o;
                if (Xml2JSONUtil.isEmpty(attr.getValue())) continue;
                json.put("@" + attr.getName(), (Object)attr.getValue());
            }
            if (e.getText().isEmpty()) continue;
            json.put(e.getName(), (Object)e.getText());
        }
    }

    private static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty() || "null".equals(str);
    }
}

