package cn.com.duiba.scrm.common.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 业务操作类型，行为日志用
 */
public enum BusinessType {

    /**
     * 登录
     */
    LOGIN_SCAN_CODE("0001-0001","扫码登录"),

    /**
     * 个人活码
     */
    EMPLE_CODE_SAVE("0002-0001","个人活码保存"),
    EMPLE_CODE_LOSE_EFFECT("0002-0002","个人活码失效"),
    EMPLE_CODE_DELETE("0002-0003","个人活码删除"),


    /**
     * 群活码
     */
    EMPLE_CODE_GROUP_SAVE("0003-0001","群活码保存"),
    EMPLE_CODE_GROUP_LOSE_EFFECT("0003-0002","群活码失效"),
    EMPLE_CODE_GROUP_DELETE("0003-0003","群活码删除"),

    /**
     * 客户群
     */
    CHAT_GROUP_SYNC("0004-0001","客户群同步"),
    CHAT_GROUP_EXPORT("0004-0001","导出群聊列表"),
    CHAT_GROUP_MEMBER_EXPORT("0004-0001","导出群成员列表"),

    ;
    /**
     * 八位数数字编码
     * 前四位为模块编码,PartTitleEnum.title
     * 后四位为操作编码
     * 例如扫码登录:0001-0001
     */
    private String type;
    /**
     * 操作名称
     */
    private String typeName;

    BusinessType(String type, String titleName) {
        this.type = type;
        this.typeName = titleName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }


    public static BusinessType getByType(String type) {
        for (BusinessType value : BusinessType.values()) {
            if (StringUtils.equals(type, value.getType())) {
                return value;
            }
        }
        return null;
    }
}
