package cn.com.duiba.scrm.common.enums.log;

import cn.com.duiba.scrm.common.enums.BusinessType;
import org.apache.commons.lang.StringUtils;

public enum PartTitleEnum {

    LOGIN("0001","登录"),
    EMPLE_CODE("0002","个人活码"),
    EMPLE_CODE_GROUP("0003","群活码"),
    CHAT_GROUP("0004","客户群"),

    ;
    /**
     * 四位数数字编码,例如登录0001
     */
    private String title;
    /**
     * 模块名称
     */
    private String titleName;

    PartTitleEnum(String title, String titleName) {
        this.title = title;
        this.titleName = titleName;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleName() {
        return titleName;
    }

    public void setTitleName(String titleName) {
        this.titleName = titleName;
    }


    public static PartTitleEnum getByTitle(String title) {
        for (PartTitleEnum value : PartTitleEnum.values()) {
            if (StringUtils.equals(title, value.getTitle())) {
                return value;
            }
        }
        return null;
    }
}
