package cn.com.duiba.scrm.common.enums.groupmsg;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description: 群发任务状态
 * @date 2021/7/30 20:17
 */
public enum GroupMsgStatusEnum {

    /**
     * 群发任务状态
     */
    SEND_SUCCESS(1, "发送成功"),
    SEND_WAIT(2, "待发送"),
    SEND_FAIL(3, "发送失败"),
    SEND_CANCEL(4, "已取消"),
    SENDING(5, "发送中");

    private final Integer type;
    private final String desc;

    GroupMsgStatusEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static GroupMsgStatusEnum getStatus(Integer type) {
        for (GroupMsgStatusEnum groupMsgStatusEnum : GroupMsgStatusEnum.values()) {
            if (groupMsgStatusEnum.getType().equals(type)) {
                return groupMsgStatusEnum;
            }
        }
        return null;
    }
}
