package cn.com.duiba.scrm.common.enums.groupmsg;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description: 成员发送任务状态
 * @date 2021/7/30 20:24
 */
public enum GroupMsgTaskEnum {

    /**
     * 成员发送任务状态
     */
    NOT_SEND(0, "未发送"),
    SEND(2, "已发送");

    private final Integer type;
    private final String desc;

    GroupMsgTaskEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static GroupMsgTaskEnum getTask(Integer type) {
        for (GroupMsgTaskEnum taskEnum : GroupMsgTaskEnum.values()) {
            if (taskEnum.getType().equals(type)) {
                return taskEnum;
            }
        }
        return null;
    }
}
