package cn.com.duiba.scrm.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author wangxukai
 * @description 企微第三方应用推送消息
 * @date ：Created in 2021/7/8
 */
public enum SuiteMessageEnum {
    SUITE_TICKET("suite_ticket","推送suite_ticket"),
    AUTH_SUCCESS("create_auth","授权成功通知"),
    AUTH_CHANGE("change_auth","变更授权通知"),
    AUTH_CANCEL("cancel_auth","取消授权通知"),
    ;

    private String eventName;

    private String desc;

    SuiteMessageEnum(String eventName,String desc){
        this.eventName = eventName;
        this.desc = desc;
    }

    public static SuiteMessageEnum getByCode(String code){
        for (SuiteMessageEnum corpWxSuiteMessageEnum : SuiteMessageEnum.values()){
            if(corpWxSuiteMessageEnum.getEventName().equals(code)){
                return corpWxSuiteMessageEnum;
            }
        }
        return null;
    }

    public String getEventName() {
        return eventName;
    }

    public String getDesc() {
        return desc;
    }
}
