package cn.com.duiba.scrm.common.util;

import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by xiaotian on 2019-03-23.
 */
public class FormatUtils {
    private FormatUtils(){}

    public static String format(String template, Map<String,Object> params){
        if(MapUtils.isEmpty(params)){
            params = new HashMap<>();
        }
        if(StringUtils.isBlank(template)){
            return template;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile("\\{\\{.*?\\}\\}").matcher(template);
        while (m.find()) {
            String param = m.group();
            Object value = params.get(param.substring(2, param.length() - 2));
            m.appendReplacement(sb, value==null ? "" : Matcher.quoteReplacement(value.toString()));
        }
        m.appendTail(sb);
        String message = sb.toString();
        message = message.replaceAll("\\[n\\]","\n");
        message = message.replaceAll("\\[t\\]","\t");
        message = message.replaceAll("\\[s\\]"," ");
        return message;
    }

    public static String subLargeString(String source,int maxLength,int shotLength){
        if(StringUtils.isBlank(source) || source.length()<=maxLength){
            return source;
        }
        return source.substring(0,shotLength)+"...";
    }

    public static String quoteReplacement(String title) {
        if (StringUtils.isBlank(title) || !title.contains("\"")) {
            return title;
        }
        title = Matcher.quoteReplacement(title);
        title = StringUtils.replaceOnce(title, "\"", "“");
        title = StringUtils.replaceOnce(title, "\"", "”");
        title = StringUtils.replaceOnce(title, "\"", "“");
        title = StringUtils.replaceOnce(title, "\"", "”");
        return title;
    }
}
