package cn.com.duiba.scrm.common.util;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.*;

/**
 * Created by zhangshun on 2019/1/31.
 */
public class RequestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestUtils.class);


    private RequestUtils() {
        //to do something
    }

    /**
     * 根据名称获取cookie
     *
     * @return
     */
    public static String getCookie(HttpServletRequest request, String key) {
        return getCookies(request).get(key);
    }

    /**
     * 获取所有cookie
     *
     * @return
     */
    public static Map<String, String> getCookies(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (Objects.isNull(cookies)) {
            return Collections.emptyMap();
        }
        Map<String, String> cookieMap = new HashMap<>();
        for (Cookie c : cookies) {
            cookieMap.put(c.getName(), c.getValue());
        }
        return cookieMap;
    }

    /**
     * 获取登录信息
     *
     * @param request
     * @param key
     * @return
     */
    public static String getLoginCookieValue(HttpServletRequest request, String key) {
        String value = request.getHeader(key);
        if (StringUtils.isNotBlank(value)) {
            return value;
        }
        if (SpringEnvironmentUtils.isDevEnv() || SpringEnvironmentUtils.isTestEnv()) {
            value = request.getParameter(key);
            if (StringUtils.isNotBlank(value)) {
                return value;
            }
        }
        return getCookie(request, key);
    }


    public static Map<String, List<String>> getAllHeaders(HttpServletRequest request) {
        Enumeration<String> headerNames = request.getHeaderNames();
        if (headerNames == null || !headerNames.hasMoreElements()) {
            return Collections.emptyMap();
        }
        Map<String, List<String>> headers = new HashMap<>();
        while (headerNames.hasMoreElements()) {
            String name = headerNames.nextElement();
            List<String> valueList = new ArrayList<>();
            headers.put(name, valueList);
            Enumeration<String> values = request.getHeaders(name);
            if (values == null || !values.hasMoreElements()) {
                continue;
            }
            while (values.hasMoreElements()) {
                valueList.add(values.nextElement());
            }
        }
        return headers;
    }


    public static String getInputSteam(HttpServletRequest request) {
        try (InputStream in = request.getInputStream()) {
            StringBuilder out = new StringBuilder();
            byte[] b = new byte[1024];
            for (int n; (n = in.read(b)) != -1; ) {
                out.append(new String(b, 0, n));
            }
            return out.toString();
        } catch (Exception e) {
            // ignore
            LOGGER.warn("获取RequestInputStream错误", e);
        }
        return StringUtils.EMPTY;
    }

}
