package cn.com.duiba.scrm.common.enums;

/**
 * @author wangxukai
 * @description 企微第三方应用推送消息事件类型
 * @date ：Created in 2021/7/8
 */
public enum SuiteMessageInfoEnum {
    SUITE_TICKET("suite_ticket","推送suite_ticket"),
    AUTH_SUCCESS("create_auth","授权成功通知"),
    AUTH_CHANGE("change_auth","变更授权通知"),
    AUTH_CANCEL("cancel_auth","取消授权通知"),
    CHANGE_CONTACT("change_contact","成员事件"),
    SHARE_AGENT_CHANGE("share_agent_change","共享应用事件"),
    BATCH_JOB_RESULT("batch_job_result","异步任务完成通知"),
    CHANGE_EXTERNAL_CONTACT("change_external_contact","外部联系人事件"),
    CHANGE_EXTERNAL_CHAT("change_external_chat","客户群事件"),
    CHANGE_EXTERNAL_TAG("change_external_tag","客户标签事件"),
    SUBSCRIBE("subscribe","关注"),
    UNSUBSCRIBE("unsubscribe","取消关注");


    ;

    private String infoType;

    private String desc;

    SuiteMessageInfoEnum(String infoType, String desc){
        this.infoType = infoType;
        this.desc = desc;
    }

    public static SuiteMessageInfoEnum getByCode(String code){
        for (SuiteMessageInfoEnum corpWxSuiteMessageInfoEnum : SuiteMessageInfoEnum.values()){
            if(corpWxSuiteMessageInfoEnum.getInfoType().equals(code)){
                return corpWxSuiteMessageInfoEnum;
            }
        }
        return null;
    }

    public String getInfoType() {
        return infoType;
    }

    public String getDesc() {
        return desc;
    }
}
