package cn.com.duiba.scrm.common.enums.groupmsg;

import org.apache.commons.lang3.StringUtils;

/**
 * @author yuanzhixin
 * @version 1.0
 * @description: 群发任务发送方式
 * @date 2021/7/30 20:15
 */
public enum GroupMsgSendTypeEnum {

    /**
     * 群发类型
     */
    SENDING(1, "立即发送"),
    TIME_SENDING(2, "定时发送");

    private final Integer type;
    private final String desc;

    GroupMsgSendTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static GroupMsgSendTypeEnum getSendType(Integer type) {
        for (GroupMsgSendTypeEnum sendTypeEnum : GroupMsgSendTypeEnum.values()) {
            if (sendTypeEnum.getType().equals(type)) {
                return sendTypeEnum;
            }
        }
        return null;
    }
}
