package cn.com.duiba.scrm.common.enums.log;

import cn.com.duiba.scrm.common.enums.BusinessType;
import org.apache.commons.lang.StringUtils;

public enum PartTitleEnum {

    LOGIN("LOGIN","登录"),
    EMPLE_CODE("EMPLE_CODE","个人活码"),
    EMPLE_CODE_GROUP("EMPLE_CODE_GROUP","群活码"),
    CHAT_GROUP("CHAT_GROUP","客户群"),
    GROUP_MSG("GROUP_MSG","客户群发"),
    MATERIAL("MATERIAL","素材"),
    PHARSE("PHARSE","话术"),
    ROLE("ROLE","角色"),
    WECHAT_USER("WECHAT_USER","员工"),
    WELCOME_MSG("WELCOME_MSG","个人欢迎语"),
    WELCOME_MSG_GROUP("WELCOME_MSG_GROUP","入群欢迎语"),
    TAG("TAG","标签"),
    SUITE_CONF("SUITE_CONF","应用配置"),
    CORP_WX("CORP_WX","企微信息配置"),

    ;
    /**
     * 四位数数字编码,例如登录0001
     */
    private String title;
    /**
     * 模块名称
     */
    private String titleName;

    PartTitleEnum(String title, String titleName) {
        this.title = title;
        this.titleName = titleName;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleName() {
        return titleName;
    }

    public void setTitleName(String titleName) {
        this.titleName = titleName;
    }


    public static PartTitleEnum getByTitle(String title) {
        for (PartTitleEnum value : PartTitleEnum.values()) {
            if (StringUtils.equals(title, value.getTitle())) {
                return value;
            }
        }
        return null;
    }
}
