/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.common.util;

import org.apache.commons.lang3.StringUtils;

public class EmojiUtils {
    private static boolean isCharacter(char codePoint) {
        return codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff';
    }

    public static String filterEmoji(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return source;
        }
        StringBuilder buf = null;
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (!EmojiUtils.isCharacter(codePoint)) continue;
            if (buf == null) {
                buf = new StringBuilder(source.length());
            }
            buf.append(codePoint);
        }
        if (buf == null) {
            return "";
        }
        if (buf.length() == len) {
            buf = null;
            return source;
        }
        return buf.toString();
    }

    public static String replaceEmoji(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return source;
        }
        int len = source.length();
        StringBuilder buf = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (EmojiUtils.isCharacter(codePoint)) {
                buf.append(codePoint);
                continue;
            }
            buf.append("\u56d7");
            ++i;
        }
        return EmojiUtils.getResult(source, buf);
    }

    private static String getResult(String source, StringBuilder buf) {
        if (buf == null) {
            return "";
        }
        if (buf.length() == source.length()) {
            return source;
        }
        return buf.toString();
    }

    public static Boolean containsEmoji(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return false;
        }
        int len = source.length();
        boolean containsEmoji = false;
        for (int i = 0; i < len; ++i) {
            char hs = source.charAt(i);
            if (EmojiUtils.isCharacter(hs)) continue;
            containsEmoji = true;
            break;
        }
        return containsEmoji;
    }
}

