/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.common.enums.db.channel;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum DefaultRadarChannelEnum {
    EMPLE_CODE(1L, "\u4e2a\u4eba\u6d3b\u7801"),
    WELCOME_MSG(2L, "\u597d\u53cb\u6b22\u8fce\u8bed"),
    CUSTOMER_MSG(3L, "\u5ba2\u6237\u7fa4\u53d1"),
    CUSTOMER_GROUP_MSG(4L, "\u5ba2\u6237\u7fa4\u7fa4\u53d1"),
    GROUP_SOP(5L, "\u7fa4sop"),
    QUICK_SHORTCUT(6L, "\u5feb\u6377\u56de\u590d-\u8bdd\u672f\u5e93"),
    QUICK_RADAR(7L, "\u5feb\u6377\u56de\u590d-\u96f7\u8fbe\u94fe\u63a5");

    private Long channel;
    private String desc;
    private static Map<Long, DefaultRadarChannelEnum> valueMap;

    private DefaultRadarChannelEnum(Long channel, String desc) {
        this.channel = channel;
        this.desc = desc;
    }

    public Long getChannel() {
        return this.channel;
    }

    public String getDesc() {
        return this.desc;
    }

    public static String getChannelName(Long channelId) {
        if (Objects.isNull(channelId)) {
            return "";
        }
        DefaultRadarChannelEnum channelEnum = valueMap.get(channelId);
        if (channelEnum != null) {
            return channelEnum.getDesc();
        }
        return "";
    }

    static {
        valueMap = new HashMap<Long, DefaultRadarChannelEnum>();
        for (DefaultRadarChannelEnum value : DefaultRadarChannelEnum.values()) {
            valueMap.put(value.getChannel(), value);
        }
    }
}

