/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.scrm.common.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

public class QrCodeUtil {
    public static String stringToBase64(String content, String headImg) throws WriterException, IOException {
        BufferedImage bufferedImage = QrCodeUtil.codeAddHeadToImage(content, headImg);
        ByteArrayOutputStream outputStream1 = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", outputStream1);
        Base64.Encoder encoder1 = Base64.getEncoder();
        return "data:image/jpeg;base64," + encoder1.encodeToString(outputStream1.toByteArray());
    }

    private static BufferedImage codeAddHeadToImage(String content, String headImg) throws WriterException, IOException {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 0);
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, 600, 600, hints);
        BufferedImage bufferedImage = QrCodeUtil.toBufferedImage(bitMatrix);
        if (StringUtils.isNotBlank((CharSequence)headImg)) {
            bufferedImage = QrCodeUtil.logoMatrix(bufferedImage, headImg);
        }
        return bufferedImage;
    }

    private static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public static void main(String[] args) throws IOException, WriterException, NotFoundException {
        QrCodeUtil.urlToLink("https://wework.qpic.cn/wwpic/381128_UddXPXhuSLaXwNm_1627385399/0");
    }

    public static BufferedImage logoMatrix(BufferedImage matrixImage, String logoUrl) throws IOException {
        Graphics2D g2 = matrixImage.createGraphics();
        int matrixWidth = matrixImage.getWidth();
        int matrixHeigh = matrixImage.getHeight();
        BufferedImage logo = ImageIO.read(new URL(logoUrl));
        g2.drawImage(logo, matrixWidth / 5 * 2, matrixHeigh / 5 * 2, matrixWidth / 5, matrixHeigh / 5, null);
        BasicStroke stroke = new BasicStroke(5.0f, 1, 1);
        g2.setStroke(stroke);
        RoundRectangle2D.Float round = new RoundRectangle2D.Float(matrixWidth / 5 * 2, matrixHeigh / 5 * 2, matrixWidth / 5, matrixHeigh / 5, 20.0f, 20.0f);
        g2.setColor(Color.white);
        g2.draw(round);
        BasicStroke stroke2 = new BasicStroke(1.0f, 1, 1);
        g2.setStroke(stroke2);
        RoundRectangle2D.Float round2 = new RoundRectangle2D.Float(matrixWidth / 5 * 2 + 2, matrixHeigh / 5 * 2 + 2, matrixWidth / 5 - 4, matrixHeigh / 5 - 4, 20.0f, 20.0f);
        g2.setColor(new Color(128, 128, 128));
        g2.draw(round2);
        g2.dispose();
        matrixImage.flush();
        return matrixImage;
    }

    public static String urlToLink(String codeUrl) throws IOException, NotFoundException {
        BufferedImage image = ImageIO.read(new URL(codeUrl));
        MultiFormatReader formatReader = new MultiFormatReader();
        BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
        HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
        HashMap<EncodeHintType, String> map = new HashMap<EncodeHintType, String>();
        map.put(EncodeHintType.CHARACTER_SET, "utf-8");
        Result result = formatReader.decode(binaryBitmap, map);
        System.out.println("\u89e3\u6790\u7ed3\u679c\uff1a" + result.toString());
        return result.toString();
    }

    public static BufferedImage codeAddHead(String codeUrl, String headUrl) throws IOException, NotFoundException, WriterException {
        return QrCodeUtil.codeAddHeadToImage(QrCodeUtil.urlToLink(codeUrl), headUrl);
    }
}

