package cn.com.duiba.scrm.common.mq;

import cn.com.duiba.scrm.common.annotation.mq.MqConsumerMethod;
import cn.com.duiba.scrm.common.enums.mq.ScrmMqTagEnum;
import cn.com.duiba.scrm.common.enums.mq.ScrmMqTopicEnum;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/10/25
 */
@Slf4j
public class MqConsumerManager {


    private static final Map<String,ConcurrentHashMap<String, List<ConsumerMethod>>> MQ_METHOD_MAP = new ConcurrentHashMap<>();

    /**
     * 获取消息处理器
     *
     * @param topic mq topic
     * @param tag   mq tag
     * @return 消息处理器
     */
    public static List<ConsumerMethod> get(String topic, String tag) {
        Map<String, List<ConsumerMethod>> tagMqConsumerMap = MQ_METHOD_MAP.get(topic);
        if (tagMqConsumerMap == null) {
            return null;
        }
        return tagMqConsumerMap.get(tag);
    }

    public static void put(ConsumerMethod method){
        MqConsumerMethod annotation = method.getAnnotation();
        Map<String, List<ConsumerMethod>> tagMqConsumerMap = MQ_METHOD_MAP.computeIfAbsent(annotation.topic().getTopic(), k -> new ConcurrentHashMap<>());
        List<ConsumerMethod> methods = tagMqConsumerMap.computeIfAbsent(annotation.tag().getTag(), k -> new ArrayList<>());
        methods.add(method);
    }
}
