package cn.com.duiba.scrm.common.enums;

import org.apache.commons.lang.StringUtils;

/**
 * 业务操作类型，行为日志用
 */
public enum BusinessType {

    /**
     * 登录
     */
    LOGIN_SCAN_CODE("LOGIN_SCAN_CODE","扫码登录"),
    LOGIN_WEB("LOGIN_WEB","WEB登录"),

    /**
     * 个人活码
     */
    EMPLE_CODE_SAVE("EMPLE_CODE_SAVE","个人活码保存"),
    EMPLE_CODE_LOSE_EFFECT("EMPLE_CODE_LOSE_EFFECT","个人活码失效"),
    EMPLE_CODE_DELETE("EMPLE_CODE_DELETE","个人活码删除"),


    /**
     * 群活码
     */
    EMPLE_CODE_GROUP_SAVE("EMPLE_CODE_GROUP_SAVE","群活码保存"),
    EMPLE_CODE_GROUP_LOSE_EFFECT("EMPLE_CODE_GROUP_LOSE_EFFECT","群活码失效"),
    EMPLE_CODE_GROUP_DELETE("EMPLE_CODE_GROUP_DELETE","群活码删除"),

    /**
     * 客户群
     */
    CHAT_GROUP_SYNC("CHAT_GROUP_SYNC","客户群同步"),
    CHAT_GROUP_EXPORT("CHAT_GROUP_EXPORT","导出群聊列表"),
    CHAT_GROUP_MEMBER_EXPORT("CHAT_GROUP_MEMBER_EXPORT","导出群成员列表"),

    /**
     * 客户群发
     */
    GROUP_MSG_CREATE("GROUP_MSG_CREATE","创建客户群发、群群发"),
    GROUP_MSG_CANCEL("GROUP_MSG_CANCEL","取消客户群发"),
    GROUP_MSG_REMIND("GROUP_MSG_REMIND","提醒发送"),

    /**
     * 素材
     */
    MATERIAL_ADD("MATERIAL_ADD","添加素材"),
    MATERIAL_DELETE("MATERIAL_DELETE","素材删除"),
    MATERIAL_UPDATE("MATERIAL_UPDATE","素材更新"),

    /**
     * 话术
     */
    PHARSE_GROUP_ADD("PHARSE_GROUP_ADD","话术组增加"),
    PHARSE_GROUP_DELETE("PHARSE_GROUP_DELETE","话术组删除"),
    PHARSE_GROUP_UPDATE("PHARSE_GROUP_UPDATE","话术组更新"),
    PHARSE_ADD("PHARSE_ADD","新建话术"),
    PHARSE_UPDATE("PHARSE_UPDATE","话术更新"),
    PHARSE_BATCH_UPDATE("PHARSE_BATCH_UPDATE","话术批量更新"),
    PHARSE_GROUP_UPDATE_SORT("PHARSE_GROUP_UPDATE_SORT","更新分组排序"),
    PHARSE_IMPORT("PHARSE_IMPORT","导入"),

    /**
     * 角色
     */
    ROLE_BAND_USER_ROLE_DEPT("ROLE_BAND_USER_ROLE_DEPT","编辑员工的管理部门"),
    ROLE_BAND_CREATOR("ROLE_BAND_CREATOR","换绑创建者"),
    ROLE_BAND_USER_ROLE("ROLE_BAND_USER_ROLE","员工绑定角色"),

    /**
     * 员工
     */
    WECHAT_USER_SYNC("WECHAT_USER_SYNC","员工同步"),


    /**
     * 个人欢迎语
     */
    WELCOME_MSG_SAVE("WELCOME_MSG_SAVE","保存个人欢迎语"),
    WELCOME_MSG_DELETE("WELCOME_MSG_DELETE","删除个人欢迎语"),

    /**
     * 入群欢迎语
     */
    WELCOME_MSG_GROUP_SAVE("WELCOME_MSG_GROUP_SAVE","保存入群欢迎语"),
    WELCOME_MSG_GROUP_DELETE("WELCOME_MSG_GROUP_DELETE","删除入群欢迎语"),

    /**
     * 标签
     */
    TAG_ADD("TAG_ADD","添加标签"),
    TAG_UPDATE("TAG_UPDATE","修改标签"),
    TAG_DELETE("TAG_DELETE","删除标签"),
    TAG_SYNC("TAG_SYNC","同步标签"),

    /**
     * 应用配置
     */
    SUITE_CONF_PRE_AUTH_URL("SUITE_CONF_PRE_AUTH_URL","获取授权跳转页面"),
    SUITE_CONF_SAVE_SELF_SUITE("SUITE_CONF_SAVE_SELF_SUITE","保存自建应用"),

    /**
     * 企微信息配置
     */
    CORP_WX_UPDATE_CORP_ACCOUNT("CORP_WX_UPDATE_CORP_ACCOUNT","修改企微信息"),



    ;
    /**
     * 八位数数字编码
     * 前四位为模块编码,PartTitleEnum.title
     * 后四位为操作编码
     * 例如扫码登录:0001-0001
     */
    private String type;
    /**
     * 操作名称
     */
    private String typeName;

    BusinessType(String type, String titleName) {
        this.type = type;
        this.typeName = titleName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }


    public static BusinessType getByType(String type) {
        for (BusinessType value : BusinessType.values()) {
            if (StringUtils.equals(type, value.getType())) {
                return value;
            }
        }
        return null;
    }
}
