package cn.com.duiba.scrm.common.enums.db.channel;

import cn.com.duiba.scrm.common.enums.wechat.WxErrorCodeEnum;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author wangxukai
 * @description 雷达分享默认渠道
 * @date ：Created in 2021/8/30
 */
public enum DefaultRadarChannelEnum {

    EMPLE_CODE(1L,"个人活码"),
    WELCOME_MSG(2L,"好友欢迎语"),
    CUSTOMER_MSG(3L,"客户群发"),
    CUSTOMER_GROUP_MSG(4L,"客户群群发"),
    GROUP_SOP(5L,"群sop"),
    QUICK_SHORTCUT(6L,"快捷回复-话术库"),
    QUICK_RADAR(7L,"快捷回复-雷达链接");

    private Long channel;

    private String desc;

    DefaultRadarChannelEnum(Long channel, String desc){
        this.channel = channel;
        this.desc = desc;
    }

    public Long getChannel() {
        return channel;
    }

    public String getDesc() {
        return desc;
    }

    private static Map<Long, DefaultRadarChannelEnum> valueMap = new HashMap<>();

    static {
        for (DefaultRadarChannelEnum value : DefaultRadarChannelEnum.values()) {
            valueMap.put(value.getChannel(), value);
        }
    }
    public static String getChannelName(Long channelId){
        if(Objects.isNull(channelId)){
            return "";
        }
        DefaultRadarChannelEnum channelEnum = valueMap.get(channelId);
        if(channelEnum != null){
            return channelEnum.getDesc();
        }
        return "";
    }
}
