package cn.com.duiba.scrm.common.util;

import cn.com.duiba.scrm.common.constants.DefaultConstant;
import cn.com.duiba.wolf.utils.UrlUtils2;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/10/22 15:42
 */
public class UrlUtils {

    private UrlUtils(){}


    public static String addHttpsHeader(String url){
        if(!StringUtils.startsWith(url, DefaultConstant.HTTP)){
            url = DefaultConstant.HTTPS + DefaultConstant.ARTICLE_SUGGESTION_LABEL + url;
        }
        return url;
    }

    /**
     * 把object的所有非空属性加到URL中。
     * @param url 原始URL
     * @param obj 对象。不支持多层级的object哦。支持@JSONFiled
     */
    @Nullable
    public static String appendObject2Url(String url, Serializable obj){
        if (StringUtils.isBlank(url) || Objects.isNull(obj)){
            return null;
        }
        Map<String, String> paramMap = changeObject2Map(obj);
        return UrlUtils2.appendParams(url,paramMap);
    }


    @NotNull
    public static Map<String, String> changeObject2Map(Object obj) {
        if (Objects.isNull(obj)){
            return new HashMap<>();
        }
        Object json = JSON.toJSON(obj);
        if (!(json instanceof JSONObject)){
            throw new UnsupportedOperationException("不支持的参数类型!");
        }
        JSONObject jsonObject = (JSONObject) json;
        Map<String, String> map = new HashMap<>();
        jsonObject.forEach((key,value)-> {
            String value1 = Objects.toString(value, "");
            if (StringUtils.isNotBlank(value1)){
                map.put(key, value1);
            }
        });
        return map;
    }

}
