package cn.com.duiba.scrm.wechat.service.api.remoteservice.service.auth;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.common.result.ScrmResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.auth.CorpWxAuthParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.auth.SuitePreAuthCodeParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.auth.SuiteCorpWxAuthResult;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/7
 */
@AdvancedFeignClient
public interface RemoteSuiteAuthService {



    /**
     * 获取企微永久授权码以及授权信息
     * https://open.work.weixin.qq.com/api/doc/90001/90143/90603
     * @param param
     * @return
     */
    ScrmResult<SuiteCorpWxAuthResult> getCorpWxPermanent(CorpWxAuthParam param);

    /**
     * 获取预授权码
     *
     * @param param
     * @return
     */
    ScrmResult<String> getPreAuthCode(SuitePreAuthCodeParam param);
}
