package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.customer;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GroupChatListParam extends BaseParam {

    private GroupChatListParamBean paramBean;

    @Data
    public static class GroupChatListParamBean{
        /**群状态过滤: 0 - 所有列表;1 - 离职待继承;2 - 离职继承中;3 - 离职继承完成; */
        @JSONField(name = "status_filter")
        private Integer statusFilter;

        /**分页，偏移量。默认为0 */
        @JSONField(name = "offset")
        private Integer offset=new Integer(0);

        /**分页，预期请求的数据量，取值范围 1 ~ 1000 */
        @JSONField(name = "limit")
        private Integer limit=new Integer(1000);
    }
}
