package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.customer;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/15
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WeCustomerMessagePushParam extends BaseParam {

    private WeCustomerMessagePushParamBean weCustomerMessagePushParamBean;
    @Data
    public class WeCustomerMessagePushParamBean implements Serializable {

        /**
         * 群发任务的类型，默认为single，表示发送给客户，group表示发送给客户群
         */
        @JSONField(name = "chat_type")
        private String chatType;

        /**
         * 客户的外部联系人id列表，仅在chat_type为single时有效，不可与sender同时为空，最多可传入1万个客户
         */
        @JSONField(name = "external_userid")
        private List<String> externalUserId;

        /**
         * 	发送企业群发消息的成员userid，当类型为发送给客户群时必填
         */
        @JSONField(name = "sender")
        private String sender;

        /**
         *文本消息
         */
        @JSONField(name = "text")
        private TextMessageParamBean text;

        /**
         * 附件
         */
        @JSONField(name = "attachments")
        private List attachments;

        /**
         * 图片消息
         */
        //private ImageMessageDto image;

        /**
         * 链接消息
         */
        //private LinkMessageDto link;

        /**
         * 小程序消息
         */
        //private MiniprogramMessageDto miniprogram;

        public class TextMessageParamBean{
            /**
             * 消息文本内容，最多4000个字节
             */
            @JSONField(name = "content")
            private String content;
        }
    }
}
