package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.user;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/17
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class LeaveWeUsersParam extends BaseParam {

    private LeaveWeUsersParamBean paramBean;

    public class LeaveWeUsersParamBean{

        /**
         * 分页查询，要查询页号，从0开始
         */
        @JSONField(name = "page_id")
        private Integer pageId;


        /**
         * 每次返回的最大记录数，默认为1000，最大值为1000
         */
        @JSONField(name = "cursor")
        private String cursor;

        /**
         * 分页查询游标，字符串类型，适用于数据量较大的情况，如果使用该参数则无需填写page_id，该参数由上一次调用返回
         */
        @JSONField(name = "page_size")
        private Integer pageSize;
    }
}
