package cn.com.duiba.scrm.wechat.service.api.remoteservice.result.auth.provider;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/15
 */
@Data
public class ProviderLoginUserInfoBean implements Serializable {

    /**
     * 登录用户的userid，登录用户在通讯录中时返回
     */
    @JSONField(name = "userid")
    private String userId;

    /**
     * 全局唯一。对于同一个服务商，不同应用获取到企业内同一个成员的open_userid是相同的，最多64个字节。 登录用户在通讯录中返回
     */
    @JSONField(name = "open_userid")
    private String openUserId;

    /**
     * 登录用户的名字，登录用户在通讯录中时返回，此字段从2019年12月30日起，对新创建服务商不再返回，2020年6月30日起，对所有历史服务商不再返回真实name，使用userid代替name返回，第三方页面需要通过通讯录展示组件来展示名字
     */
    @JSONField(name = "name")
    private String name;

    /**
     * 登录用户的头像，登录用户在通讯录中时返回
     */
    @JSONField(name = "avatar")
    private String avatar;
}
