package cn.com.duiba.scrm.wechat.service.api.remoteservice.result.customer;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.BaseResult;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class QueryCustomerMessageStatusResult extends BaseResult {

    /**
     * 返回查询信息列表
     */
    @JSONField(name = "detail_list")
    private List<DetailMessageStatusResult> detailList;

    @JSONField(name = "check_status")
    private String checkStatus;

    @Data
    public class DetailMessageStatusResult {
        /**
         *  外部联系人userid，群发消息到企业的客户群不吐出该字段
         */
        @JSONField(name = "external_userid")
        private String externalUserId;

        /**
         * 外部客户群id，群发消息到客户不吐出该字段
         */
        @JSONField(name = "chat_id")
        private String chatId;

        /**
         * 企业服务人员的userid
         */
        @JSONField(name = "userid")
        private String userId;

        /**
         * 发送状态 0-未发送 1-已发送 2-因客户不是好友导致发送失败 3-因客户已经收到其他群发消息导致发送失败
         */
        @JSONField(name = "status")
        private String status;

        /**
         * 发送时间，发送状态为1时返回(为时间戳的形式)
         */
        @JSONField(name = "send_time")
        private String sendTime;

    }
}
