package cn.com.duiba.scrm.wechat.service.api.remoteservice.result.msg;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.BaseResult;
import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WeMsgAuditResult extends BaseResult {

    /**
     * 设置在开启范围内的成员的userid列表
     */
    @JSONField(name = "ids")
    private List<String> ids;

    /**
     * 同意情况
     */
    @JSONField(name = "info")
    private List<AgreeInfo> agreeInfo;

    /**
     * roomid对应的群名称
     */
    @JSONField(name = "roomname")
    private String roomName;

    /**
     * roomid对应的群创建者，userid
     */
    @JSONField(name = "creator")
    private String creator;

    /**
     * roomid对应的群创建时间
     */
    @JSONField(format = "room_create_time")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date roomCreateTime;

    /**
     * roomid对应的群公告
     */
    @JSONField(name = "notice")
    private String notice;

    /**
     * roomid对应的群成员列表
     */
    @JSONField(name = "members")
    private List<Member> members;

    private class Member {
        /**
         * roomid群成员的id，userid
         */
        @JSONField(name = "memberid")
        private String memberId;

        /**
         * roomid群成员的入群时间
         */
        @JSONField(name = "jointime")
        private String joinTime;
    }

    private class AgreeInfo {
        /**
         * 同意状态改变的具体时间，utc时间
         */
        @JSONField(name = "status_change_time")
        private String statusChangeTime;

        /**
         * 成员Id
         */
        @JSONField(name = "userid")
        private String userId;

        /**
         * 群内外部联系人的externalopenid
         */
        @JSONField(name = "exteranalopenid")
        private String exteranaLopenId;

        /**
         * 同意:”Agree”，不同意:”Disagree”，默认同意:”Default_Agree”
         */
        private String agreeSagreeStatustatus;
    }
}
