package cn.com.duiba.scrm.wechat.service.api.remoteservice.service.customer;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.common.result.ScrmResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.customer.QueryCustomerMessageStatusParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.customer.WeCustomerMessagePushParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.customer.QueryCustomerMessageStatusResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.customer.SendMessageResult;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@AdvancedFeignClient
public interface RemoteWeCustomerMessagePushService {


    /**
     * 添加企业群发消息任务
     * <a href="https://work.weixin.qq.com/api/doc/90000/90135/92135">API文档地址</a>
     */
    ScrmResult<SendMessageResult> sendCustomerMessageToUser(WeCustomerMessagePushParam paramBean);

    /**
     * 获取企业群发消息发送结果
     * <a href="https://work.weixin.qq.com/api/doc/90000/90135/92136">API文档地址</a>
     *
     * @param paramBean{msgid} <a href="https://work.weixin.qq.com/api/doc/90000/90135/92135">添加企业群发消息任务返回的msgid</a>
     */
    ScrmResult<QueryCustomerMessageStatusResult> queryCustomerMessageStatus( QueryCustomerMessageStatusParam paramBean);


}
