package cn.com.duiba.scrm.wechat.service.api.remoteservice.service.msg;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.common.result.ScrmResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.msg.CheckRoomAgreeParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.msg.CheckSingleAgreeParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.msg.GetPermitUserListParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.msg.GroupChatGetParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.msg.WeMsgAuditResult;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@AdvancedFeignClient
public interface RemoteWeMsgAuditService {

    /**
     * 获取会话内容存档开启成员列表
     */
    ScrmResult<WeMsgAuditResult> getPermitUserList( GetPermitUserListParam paramBean);

    /**
     * 单聊 获取会话中外部成员的同意情况
     * @param paramBean
     * @return
     */
    ScrmResult<WeMsgAuditResult> checkSingleAgree( CheckSingleAgreeParam paramBean);

    /**
     * 群聊 获取群会话中外部成员的同意情况
     * @param paramBean
     * @return
     */
    ScrmResult<WeMsgAuditResult> checkRoomAgree( CheckRoomAgreeParam paramBean);

    /**
     * 获取会话内容存档内部群信息
     * @param paramBean
     * @return
     */
    ScrmResult<WeMsgAuditResult> getGroupChat(GroupChatGetParam paramBean);
}
