package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.customer;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @description: 客户实体
 * @author: HaoN
 * @create: 2020-09-15 17:43
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class WeCustomerParam extends BaseParam {

    private WeCustomerParamBean paramBean;
    @Data
    public static class WeCustomerParamBean{


        /** 客户id集合 */
        @JSONField(name = "external_userid")
        private String[] externalUserId;

        /** 客户详情 */
        @JSONField(name = "external_contact")
        private ExternalContact externalContact;

        private WeCustomerRemark remark;


        @Data
        public class ExternalContact  implements Serializable {
            private static final long serialVersionUID = 2864974803343604713L;
            /** 外部联系人userId */
            @JSONField(name = "external_userid")
            private String externalUserId;
            /** 外部联系人名称 */
            @JSONField(name = "name")
            private String name;
            /** 外部联系人职位 */
            @JSONField(name = "position")
            private String position;
            /** 外部联系人头像 */
            @JSONField(name = "avatar")
            private String avatar;
            /** 外部联系人所在企业简称 */
            @JSONField(name = "corp_name")
            private String corpName;
            /** 外部联系人所在企业全称 */
            @JSONField(name = "corp_full_name")
            private String corpFullName;
            /** 外部联系人的类型，1表示该外部联系人是微信用户，2表示该外部联系人是企业微信用户 */
            @JSONField(name = "type")
            private Integer type;
            /** 外部联系人性别 0-未知 1-男性 2-女性 */
            @JSONField(name = "gender")
            private Integer gender;
            /** 外部联系人在微信开放平台的唯一身份标识（微信unionid），通过此字段企业可将外部联系人与公众号/小程序用户关联起来。 */
            @JSONField(name = "unionid")
            private String unionId;

        }

        @Data
        public class WeCustomerRemark {
            @JSONField(name = "userid")
            private String userId;
            @JSONField(name = "external_userid")
            private String externalUserId;
            @JSONField(name = "remark")
            private String remark;
            @JSONField(name = "description")
            private String description;
            @JSONField(name = "remark_company")
            private String remarkCompany;
            @JSONField(name = "remark_mobiles")
            private String[] remarkMobiles;
            @JSONField(name = "remark_pic_mediaid")
            private String remarkPicMediaId;
        }


//    public WeCustomer transformWeCustomer(){
//        WeCustomer weCustomer=new WeCustomer();
//
//        if(null != external_contact){
//            BeanUtils.copyPropertiesignoreOther(external_contact,weCustomer);
//        }
//
//        if(CollectionUtil.isNotEmpty(follow_user)){
//            List<WeFlowerCustomerRel> weFlowerCustomerRels=new ArrayList<>();
//            List<WeTagDto> weTagDtos=new ArrayList<>();
//            follow_user.stream().forEach(k->{
//                WeFlowerCustomerRel weFlowerCustomerRel=new WeFlowerCustomerRel();
//                BeanUtils.copyPropertiesignoreOther(k,weFlowerCustomerRel);
//                weFlowerCustomerRels.add(weFlowerCustomerRel);
//                if(CollectionUtil.isNotEmpty(k.getTags())){
//                    k.getTags().stream().forEach(v->v.setFlower_customer_rel_id(k.getId()));
//                    weTagDtos.addAll(k.getTags());
//                }
//            });
//
//        }
//
//        return weCustomer;
//    }


    }


}
