package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.customer;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author admin
 * @date 2020-11-18
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
public class WeWelcomeMsgParam extends BaseParam {

    private WeWelcomeMsgParamBean paramBean;
    @Data
    public static class WeWelcomeMsgParamBean implements Serializable {
        private static final long serialVersionUID = 4814254698983711055L;
        @JSONField(name = "welcome_code")
        private String welcomeCode;
        @JSONField(name = "text")
        private Text text;

        @Data
        public static class Text  implements Serializable{
            /**
             * 消息文本内容,最长为4000字节
             */
            @JSONField(name = "content")
            private String content;
        }
        @JSONField(name = "attachments")
        private List<Attachments> attachmentsList;

        @Data
        public static class Attachments implements Serializable{
            @JSONField(name = "msgtype")
            private String msgType;

            @JSONField(name = "image")
            private Image image;
            @JSONField(name = "link")
            private Link link;
            @JSONField(name = "miniprogram")
            private MiniProgram miniprogram;
            @JSONField(name = "video")
            private Video video;
            @JSONField(name = "file")
            private File file;
            @Data
            public static class Image  implements Serializable{
                /**
                 * 图片的media_id
                 */
                @JSONField(name = "media_id")
                private String mediaId;
                /**
                 * 图片的链接，仅可使用上传图片接口得到的链接
                 */
                @JSONField(name = "pic_url")
                private String picUrl;
            }

            @Data
            public static   class Link  implements Serializable{
                /**
                 * 图文消息标题，最长为128字节
                 */
                @JSONField(name = "title")
                private String title;
                /**
                 * 图文消息封面的url
                 */
                @JSONField(name = "picurl")
                private String picUrl;
                /**
                 * 图文消息的描述，最长为512字节
                 */
                @JSONField(name = "desc")
                private String desc;
                /**
                 * 图文消息的链接
                 */
                @JSONField(name = "url")
                private String url;
            }

            @Data
            public static class MiniProgram  implements Serializable{
                /**
                 * 小程序消息标题，最长为64字节
                 */
                @JSONField(name = "title")
                private String title;
                /**
                 * 小程序消息封面的mediaid，封面图建议尺寸为520*416
                 */
                @JSONField(name = "pic_media_id")
                private String picMediaId;
                /**
                 * 小程序appid，必须是关联到企业的小程序应用
                 */
                @JSONField(name = "appid")
                private String appId;
                /**
                 * 小程序page路径
                 */
                @JSONField(name = "page")
                private String page;
            }

            @Data
            public static class Video implements Serializable{
                @JSONField(name = "media_id")
                private String mediaId;
            }

            @Data
            public static class File implements Serializable{
                @JSONField(name = "media_id")
                private String mediaId;
            }

        }




    }

    public WeWelcomeMsgParam(WeWelcomeMsgParam.WeWelcomeMsgParamBean paramBean){
        this.paramBean = paramBean;
    }

    public WeWelcomeMsgParam(){

    }
}
