package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.external;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WeContactWayParam extends BaseParam {


    private WeContactWayParamBean weContactWayParamBean;

    @Data
    public static class WeContactWayParamBean implements Serializable {
        //系我二维码链接，仅在scene为2时返回
        @JSONField(name = "config_id")
        private String configId;
        // 联系方式类型,1-单人, 2-多人
        @JSONField(name = "type")
        private Integer type;

        //场景，1-在小程序中联系，2-通过二维码联系
        @JSONField(name = "scene")
        private Integer scene;


        //外部客户添加时是否无需验证，默认为true
        @JSONField(name = "skip_verify")
        private Boolean skipVerify;


        //使用该联系方式的用户userID列表，在type为1时为必填，且只能有一个
        @JSONField(name = "user")
        private List<String> user;

        //使用该联系方式的部门id列表，只在type为2时有效
        @JSONField(name = "party")
        private List<Long> party;


        //企业自定义的state参数，用于区分不同的添加渠道，在调用“获取外部联系人详情”时会返回该参数值，不超过30个字符
        @JSONField(name = "state")
        private String state;

        //样式
        private Integer style = 1;

        public WeContactWayParamBean() {
        }

        public WeContactWayParamBean(Integer type, Integer scene, Boolean skip_verify) {
            this.type = type;
            this.scene = scene;
            this.skipVerify = skip_verify;
        }
    }
}
