package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.tag;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.customer.WeCropGroupTagParamBean;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.*;

import java.io.Serializable;
import java.util.List;

/**
 * @description: 标签组
 * @author: HaoN
 * @create: 2020-10-17 20:02
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class WeCropGroupTagParam extends BaseParam {

    private static final long serialVersionUID = -5864939834405233163L;

    private WeCropGroupTagParamBean paramBean;


    @Data
    public static class WeCropGroupTagParamBean implements Serializable{

        private static final long serialVersionUID = -4470999692365165326L;
        @JSONField(name = "group_id")
        private String groupId;
        @JSONField(name = "group_name")
        private String groupName;
        @JSONField(name = "order")
        private Integer order;
        @JSONField(name = "deleted")
        private Boolean deleted;
        @JSONField(name = "create_time")
        private Long createTime;
        @JSONField(name = "tag")
        private List<WeCropTagParam> tag;
    }


}
