package cn.com.duiba.scrm.wechat.service.api.remoteservice.result.auth;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.BaseResult;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/18
 */
@Data
public class SuiteGetUserInfo3rdResult extends BaseResult {

    /**
     * 用户所属企业的corpid
     */
    @JSONField(name = "CorpId")
    private String corpId;

    /**
     * 用户在企业内的UserID，如果该企业与第三方应用有授权关系时，返回明文UserId，否则返回密文UserId
     */
    @JSONField(name = "UserId")
    private String userId;
    /**
     * 手机设备号(由企业微信在安装时随机生成，删除重装会改变，升级不受影响)
     */
    @JSONField(name = "DeviceId")
    private String deviceId;
    /**
     * 成员票据，最大为512字节。
     * scope为snsapi_userinfo或snsapi_privateinfo，且用户在应用可见范围之内时返回此参数。
     * 后续利用该参数可以获取用户信息或敏感信息，参见“第三方使用user_ticket获取成员详情”。
     */
    @JSONField(name = "user_ticket")
    private String userTicket;
    /**
     * user_ticket的有效时间（秒），随user_ticket一起返回
     */
    @JSONField(name = "expires_in")
    private Integer expiresIn;
    /**
     * 全局唯一。对于同一个服务商，不同应用获取到企业内同一个成员的open_userid是相同的，最多64个字节。仅第三方应用可获取
     */
    @JSONField(name = "open_userid")
    private String openId;
}
