package cn.com.duiba.scrm.wechat.service.api.remoteservice.service.tag;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.common.result.ScrmResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.tag.WeCropGroupTagParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.tag.WeCropTagDelParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.tag.WeCropTagEditParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.tag.WeFindCropTagParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.BaseResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.tag.WeCropGropTagDtlResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.tag.WeCropGroupTagListResult;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@AdvancedFeignClient
public interface RemoteWeCorpTagService {

    /**
     * 保存标签
     * @param param  dataType = "json"
     * @return
     */
    ScrmResult<WeCropGropTagDtlResult> addCorpTag(WeCropGroupTagParam param);


    /**
     * 获取所有标签 WeCropGroupTagDto
     * @return
     */
    ScrmResult<WeCropGroupTagListResult> getAllCorpTagList(BaseParam param);


    /**
     * 根据指定标签的id,获取标签详情
     * @return
     */
    ScrmResult<WeCropGroupTagListResult> getCorpTagListByTagIds(WeFindCropTagParam weFindCropTagParam);


    /**
     * 删除企业客户标签
     * @param param
     * @return
     */
    ScrmResult<BaseResult> delCorpTag(WeCropTagDelParam param);


    /**
     * 编辑企业微信标签
     * @param param
     * @return
     */
    ScrmResult<BaseResult> editCorpTag(WeCropTagEditParam param);
}
