package cn.com.duiba.scrm.wechat.service.api.remoteservice.service.user;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.scrm.common.result.ScrmResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.user.*;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.BaseResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.user.LeaveWeUserListsResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.user.WeUserInfoResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.user.WeUserListResult;
import cn.com.duiba.scrm.wechat.service.api.remoteservice.result.user.WeUserResult;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@AdvancedFeignClient
public interface RemoteWeUserService {

    /**
     * 创建用户
     * @param param
     * @return
     */
    ScrmResult<BaseResult> createUser(WeUserParam param);


    /**
     * 根据用户账号,获取用户详情信息
     * @return
     */
    ScrmResult<WeUserResult> getUserByUserId(WeFindUserParam param);


    /**
     * 更新通讯录用户
     * @param param
     * @return
     */
    ScrmResult<BaseResult> updateUser(WeUserParam param);



    /**
     * 根据账号删除指定用户
     * @param param
     * @return
     */
    ScrmResult<BaseResult> deleteUserByUserId(WeDelUserParam param);


    /**
     *  获取部门成员
     * @param param
     * @return
     */
    ScrmResult<WeUserListResult> list(WeDeptUserListParam param);


    /**
     * 分配客户
     * @return
     */
    ScrmResult<BaseResult> allocateCustomer( AllocateWeCustomerParam param);


    /**
     * 分配成员群
     * @return
     */
    ScrmResult<BaseResult> allocateGroup(AllocateWeGroupParam allocateWeGroupDto);


    /**
     * 获取离职员工列表
     * @return
     */
    ScrmResult<LeaveWeUserListsResult> leaveWeUsers(LeaveWeUsersParam param);


    /**
     * 获取访问用户身份(内部应用)
     * @param param
     * @return
     */
    ScrmResult<WeUserInfoResult> getuserinfo(WeGetUserInfoParam param);
}
