package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.agent;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2021/7/16
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AgentDetailParam extends BaseParam {

    private AgentDetailParamBean paramBean;

    @Data
    public static class AgentDetailParamBean implements Serializable {

        //企业应用id
        @JSONField(name = "agentid")
        private String agentId;
        //企业应用名称
        @JSONField(name = "name")
        private String name;
        //企业应用方形头像
        @JSONField(name = "square_logo_url")
        private String squareLogoUrl;
        //企业应用详情
        @JSONField(name = "description")
        private String description;
        //企业应用是否被停用
        @JSONField(name = "close")
        private Boolean  close;
        //企业应用可信域名
        @JSONField(name = "redirect_domain")
        private String redirectDomain;
        //企业应用是否打开地理位置上报 0：不上报；1：进入会话上报；
        @JSONField(name = "report_location_flag")
        private Integer reportLocationFlag;
        //是否上报用户进入应用事件。0：不接收；1：接收
        @JSONField(name = "isreportenter")
        private Integer isReportenter;
        //应用主页url
        @JSONField(name = "home_url")
        private String homeUrl;
        //企业应用头像的mediaid，通过素材管理接口上传图片获得mediaid，上传后会自动裁剪成方形和圆形两个头像
        @JSONField(name = "logo_mediaid")
        private String logoMediaid;

        //企业应用可见范围（人员）
        @JSONField(name = "allow_userinfos")
        private AllowUserinfos allowUserInfos;

        //企业应用可见范围（部门）
        @JSONField(name = "allow_partys")
        private AllowPartys allowPartys;



        //可见部门
        @Data
        public class AllowPartys{
            @JSONField(name = "partyid")
            private String[] partyId;

        }
        @Data
        public class AllowUserinfos{
            @JSONField(name = "user")
            private user[] user;
        }

        @Data
        public class user{
            @JSONField(name = "userid")
            private String userId;
        }
    }
}
