package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.customer;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.*;

import java.io.Serializable;

/**
 * @description: 客户标签编辑
 * @author: HaoN
 * @create: 2020-10-24 21:01
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CutomerTagEditParam extends BaseParam {

    private CutomerTagEditParamBean paramBean;

    @Data
    public static class CutomerTagEditParamBean implements Serializable {
        private static final long serialVersionUID = 9099469321456872051L;
        /**
         * 添加外部联系人的userid
         */
        @JSONField(name = "userId")
        private String userId;
        /**
         * 外部联系人userid
         */
        @JSONField(name = "external_userid")
        private String externalUserid;
        /**
         * 要标记的标签列表
         */
        @JSONField(name = "add_tag")
        private String[] addTag;
        /**要移除的标签列表*/
        @JSONField(name = "remove_tag")
        private String[] removeTag;
    }
}
