package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.tag;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.*;

import java.io.Serializable;

/**
 * @description: 标签删除参数实体
 * @author: HaoN
 * @create: 2020-10-18 00:22
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class WeCropTagDelParam extends BaseParam {

    private WeCropTagDelParamBean weCropTagDelParamBean;

    @Data
    public static class WeCropTagDelParamBean implements Serializable {
        @JSONField(name = "tag_id")
        private String[] tagId;

        @JSONField(name = "group_id")
        private String[] groupId;
        /**
         * 授权方安装的应用agentid。仅旧的第三方多应用套件需要填此参数
         */
        @JSONField(name = "agentid")
        private Long agentId;
    }

}
