package cn.com.duiba.scrm.wechat.service.api.remoteservice.params.tag;

import cn.com.duiba.scrm.wechat.service.api.remoteservice.params.BaseParam;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.*;

import java.io.Serializable;

/**
 * @description: 标签删除参数实体
 * @author: HaoN
 * @create: 2020-10-18 00:22
 **/
@EqualsAndHashCode(callSuper = true)
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class WeCropTagEditParam extends BaseParam {

    private WeCropTagEditParamBean weCropTagDelParamBean;

    @Data
    public static class WeCropTagEditParamBean implements Serializable {
        /**
         * 标签或标签组的id
         */
        @JSONField(name = "id")
        private String id;
        /**
         * 新的标签或标签组名称，最长为30个字符
         */
        @JSONField(name = "name")
        private String name;
        /**
         * 标签/标签组的次序值。order值大的排序靠前。有效的值范围是[0, 2^32)
         */
        @JSONField(name = "order")
        private Integer order;
        /**
         * 授权方安装的应用agentid。仅旧的第三方多应用套件需要填此参数
         */
        @JSONField(name = "agentid")
        private String agentId;

    }

}
